import { Camera, Mail, Phone, MapPin, Clock, Instagram, Youtube } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={36} strokeWidth={2.5} className="footer-logo-icon" />
              <h2 className="footer-logo-text">StudioPro</h2>
            </div>
            <p className="footer-description">
              Профессиональные фотостудии для ваших творческих проектов. 
              Современное оборудование и комфортные условия.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link">
                <Instagram size={24} strokeWidth={2} />
              </a>
              <a href="#" className="social-link">
                <Youtube size={24} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={20} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={20} strokeWidth={2} />
                <a href="mailto:info@studiopro.ru">info@studiopro.ru</a>
              </li>
              <li>
                <MapPin size={20} strokeWidth={2} />
                <span>г. Москва, ул. Студийная, д. 15</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Типы студий</h3>
            <ul className="footer-links">
              <li><a href="#">Студия с фоном</a></li>
              <li><a href="#">Хромакей</a></li>
              <li><a href="#">Интерьер</a></li>
              <li><a href="#">Open Space</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={18} strokeWidth={2} />
                <span>Пн-Вс: 8:00 - 24:00</span>
              </li>
            </ul>
            <div className="footer-cta">
              <p>Забронируйте студию прямо сейчас</p>
              <a href="/book" className="footer-cta-button">Забронировать</a>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 StudioPro. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

